/******************************************************************************
                                                   COPYRIGHT (c) FREESCALE 2005  
File Name          :    $RCSfile: S12XFTM1024K5V1.h,v $                    
                                                                          
Current Revision :      $Revision: 1.0 $                                  
                                                                          
PURPOSE: header file for HCS12XE ftm (program Flash and data Flash(EEEPROM)) 
         control registers block           
                                                                          
DESCRIPTION:  Defines the Flash control registers block as a datastructure
              of type tFTM.                                             
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR       DATE       DESCRIPTION OF CHANGE                        
---  ------      --------    ---------------------                        
1.0  r32151      08/09/05    - Initial coding based on S12FTS512K4V2.h and 
                               FTM BUG 0.9.2    
1.1  r32151		  01/03/06    - updated to released FTM design
                               mgstat -> mgstat0 & mgstat1 in FSTAT
                               added ersvie bits to FERCNFG
										 added ersvif bits to FERSTAT
										 
     *******************************************************************
     * File created by: Freescale East Kilbride MCD Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/
    
                                                                          

#ifndef S12XFTM1024K5V1_H         /*prevent duplicated includes */
#define S12XFTM1024K5V1_H

#include "S12_COMMON.h"

typedef union uFCLKDIV
  {
  tU08   byte;
  struct
    {
    tU08 fdiv   :7;   /*clk divider */
    tU08 fdivld :1;   /*clock divider loaded flag */
    }bit;
  }tFCLKDIV;

/* bit masks for FCLKDIV */
#define FDIVMASK 0x7F   /* flash divider mask */
#define FDIVLD   0x80

typedef union uFSEC
  {
  tU08   byte;
  struct
    {
    tU08 sec   :2;      /*memory security bit */
    tU08 rnv   :4;      /*reserved non volatile flag bits - leave erased */
    tU08 keyen :2;      /*security key access enable */
    }bit;
  }tFSEC;

/* bit masks for FSEC */
#define SEC0    0x01 
#define SEC1    0x02
#define SECMASK 0x03
#define RNV2    0x04
#define RNV3    0x08
#define RNV4    0x10
#define RNV5    0x20
#define RNVMASK 0x3C
#define KEYEN0  0x40
#define KEYEN1  0x80

#define SECURED   0x00
#define UNSECURED SEC1

typedef union uFCNFG
  {
  tU08   byte;
  struct
    {
    tU08 fsfd   :1;     /*force single fault detect */
    tU08 fdfd   :1;     /*force double fault detect */
    tU08        :2;     
    tU08 ignsf  :1;     /*ignore single fault */
    tU08        :2;     
    tU08 ccie   :1;     /*command complete interrupt enable */
    }bit;
  }tFCNFG;

/* bit masks for FCNFG */
#define FSFD   0x01  
#define FDFD   0x02  
#define IGNSF  0x10  
#define CCIE   0x80

typedef union uFERCNFG
  {
  tU08   byte;
  struct
    {
    tU08 sfdie    :1;     /*single fault detect interrupt enable */
    tU08 dfdie    :1;     /*double fault detect interrupt enable */
    tU08 ersvie0  :1;     /*EEE Error interrupt 0 enable */
    tU08 ersvie1  :1;     /*EEE Error interrupt 1 enable */
    tU08 epviolie :1;     /*EEE protection violation interrupt enable */
    tU08 eacceie  :1;     /*EEE access error interrupt enable */
    tU08 pgmerie  :1;     /*EEE program error interrupt enable */
    tU08 erserie  :1;     /*EEE erase error interrupt enable */
    }bit;
  }tFERCNFG;

/* bit masks for FERCNFG */
#define SFDIE   0x01  
#define DFDIE   0x02  
#define ERSVIE0 0x04
#define ERSVIE1 0x08
#define EPVOLIE 0x10
#define EACCEIE 0x20
#define PGMERIE 0x40
#define ERSERIE 0x80

typedef union uFSTAT
  {
  tU08   byte;
  struct
    {
    tU08 mgstat :2;     /*state machine command completion status flag */
    tU08        :1;     /*not used */
    tU08 mgbusy :1;     /*state machine busy flag */
    tU08 fpviol :1;     /*Flash protection violation flag */
    tU08 accerr :1;     /*access error flag */
    tU08        :1;     /*not used */
    tU08 ccif   :1;     /*command complete interrupt flag */
    }bit;
  }tFSTAT;

/* bit masks for FSTAT */
#define MGSTAT0 0x01  
#define MGSTAT1 0x02  
#define MGBUSY  0x08
#define FPVIOL  0x10
#define ACCERR  0x20
#define CCIF    0x80

typedef union uFERSTAT
  {
  tU08   byte;
  struct
    {
    tU08 sfdif    :1;     /*single fault detect interrupt flag */
    tU08 dfdif    :1;     /*double fault detect interrupt flag */
    tU08 ersvif0  :1;     /*EEE Error interrupt 0 flag */
    tU08 ersvif1  :1;     /*EEE Error interrupt 1 flas */
    tU08 epviolif :1;     /*EEE protection violation interrupt flag */
    tU08 eacceif  :1;     /*EEE access error interrupt flag */
    tU08 pgmerif  :1;     /*EEE program error interrupt flag */
    tU08 erserif  :1;     /*EEE erase error interrupt flag */
    }bit;
  }tFERSTAT;

/* bit masks for FERSTAT */
#define SFDIF   0x01  
#define DFDIF   0x02  
#define ERSVIF0 0x04
#define ERSVIF1 0x08
#define EPVOLIF 0x10
#define EACCEIF 0x20
#define PGMERIF 0x40
#define ERSERIF 0x80

typedef union uFPROT
  {
  tU08   byte;
  struct
    {
    tU08 fpls     :2;      /*flash protection lower address size */
    tU08 fpldis   :1;      /*flash protection lower address range disable */
    tU08 fphs     :2;      /*flash protection higher address size */
    tU08 fphdis   :1;      /*flash protection higher address range disable */
    tU08 rnv6     :1;      /*reserved NV bit - leave erased */
    tU08 fpopen   :1;      /*open block for program/erase control */
    }bit;
  }tFPROT;

/* bit masks for FPROT */
#define FPLS0     0x01  
#define FPLS1     0x02
#define FPLSMASK  0x03  /*fpls block size mask */
#define FPLDIS    0x04  
#define FPHS0     0x08  
#define FPHS1     0x10
#define FPHSMASK  0x18  /*fphs block size mask */
#define FPHDIS    0x20  
#define RNV6      0x40
#define FPOPEN    0x80

typedef union uEPROT
  {
  tU08   byte;
  struct
    {
    tU08 eps      :3;      /*protection block size: (ep+1)*64 bytes */
    tU08 epdis    :1;      /*protection disable */
    tU08 rnv      :3;      /*reserved non volatile bits - leave erased */
    tU08 epopen   :1;      /*open block for program/erase */
    }bit;
  }tEPROT;

/* bit masks for EPROT */
#define EPS0   0x01  
#define EPS1   0x02
#define EPS2   0x04  
#define EPMASK 0x07  /*ep block size mask */
#define EPDIS  0x08
#define EPOPEN 0x80

typedef union uFCCOB    /*16 bit word with byte access*/
  {
  tU16  word;           /*access whole word    */
  struct                /*access byte at a time*/
    {
    tU08  hi;
    tU08  lo;
    }byte;
  }tFCCOB;


typedef struct                /*FTM datastructure */
  {
  volatile tFCLKDIV  fclkdiv; /*flash clock divider register */
  volatile tFSEC     fsec;    /*flash security register */
  volatile tREG08    fccobix; /*flash Common Command Object (CCOB) index register */
  volatile tREG08    feccrix; /*flash ECCR index register */
  volatile tFCNFG    fcnfg;   /*flash configuration register */
  volatile tFERCNFG  fercnfg; /*flash error configuration register */
  volatile tFSTAT    fstat;   /*flash status register */
  volatile tFERSTAT  ferstat; /*flash error status register */
  volatile tFPROT    fprot;   /*program flash protection register */
  volatile tEPROT    eprot;   /*data flash (eeeprom) protection register */
  volatile tFCCOB    fccob;   /*common command object register */ 
  volatile tU16      etag;    /*EEE tag counter */
  volatile tU16      feccr;   /*CCR error result*/ 
  volatile tU08      fopt;    /*flash option register */
  }tFTM;


#endif /*S12XFTM1024K5V1_H */